package demo.frame;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.JFrame;

import demo.common.FunctionList;
import demo.common.P2PLoginPanel;
import demo.module.LoginModule;
import demo.module.RealPlayModule;
import netsdk.lib.ToolKits;
import javax.swing.JRadioButton;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import java.awt.GridBagLayout;

class P2PLoginFrame extends JFrame{
	private P2PLoginPanel pn;
	public P2PLoginFrame() {
		setTitle("P2P");
		setLayout(null);
//	    pack();
	    setSize(450, 300);
//	    setResizable(false);
	    setLocationRelativeTo(null);										
		LoginModule.init();   // 打开工程，初始化
//		try {
//            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
//        } catch (Exception e) {
//        	e.printStackTrace();
//        } 		
		pn = new P2PLoginPanel();
		add(pn);	
		pn.addCancelBtnActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				LoginModule.logout();
	    		LoginModule.cleanup();   // 关闭工程，释放资源
	    		dispose();		    		
	    		SwingUtilities.invokeLater(new Runnable() {
	    			public void run() {
	    				FunctionList demo = new FunctionList();
	    				demo.setVisible(true);
	    			}
	    		});
			}
		});
		addWindowListener(new WindowAdapter() {
	    	public void windowClosing(WindowEvent e) {
	    		LoginModule.logout();
	    		LoginModule.cleanup();   // 关闭工程，释放资源
	    		dispose();		    		
	    		SwingUtilities.invokeLater(new Runnable() {
	    			public void run() {
	    				FunctionList demo = new FunctionList();
	    				demo.setVisible(true);
	    			}
	    		});
	    	}
	    });
	}
}

public class P2PLogin {
	public static void main(String[] args) {	
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				P2PLoginFrame demo = new P2PLoginFrame();
				demo.setVisible(true);
			}
		});		
	}
}
